/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.scenegraph.io.state.com.sun.j3d.utils.geometry;

import com.sun.j3d.utils.geometry.Box;
import com.sun.j3d.utils.scenegraph.io.retained.Controller;
import com.sun.j3d.utils.scenegraph.io.retained.SymbolTableData;
import com.sun.j3d.utils.scenegraph.io.state.com.sun.j3d.utils.geometry.PrimitiveState;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.media.j3d.Appearance;
import javax.media.j3d.SceneGraphObject;

public class BoxState
extends PrimitiveState {
    private float xdim;
    private float ydim;
    private float zdim;
    private int frontAppearance;
    private int backAppearance;
    private int topAppearance;
    private int bottomAppearance;
    private int leftAppearance;
    private int rightAppearance;

    public BoxState(SymbolTableData symbolTableData, Controller controller) {
        super(symbolTableData, controller);
        if (this.node != null) {
            this.frontAppearance = controller.getSymbolTable().addReference(((Box)this.node).getShape(0).getAppearance());
            this.backAppearance = controller.getSymbolTable().addReference(((Box)this.node).getShape(1).getAppearance());
            this.topAppearance = controller.getSymbolTable().addReference(((Box)this.node).getShape(4).getAppearance());
            this.bottomAppearance = controller.getSymbolTable().addReference(((Box)this.node).getShape(5).getAppearance());
            this.leftAppearance = controller.getSymbolTable().addReference(((Box)this.node).getShape(3).getAppearance());
            this.rightAppearance = controller.getSymbolTable().addReference(((Box)this.node).getShape(2).getAppearance());
        }
    }

    public void writeObject(DataOutput dataOutput) throws IOException {
        super.writeObject(dataOutput);
        dataOutput.writeInt(this.frontAppearance);
        dataOutput.writeInt(this.backAppearance);
        dataOutput.writeInt(this.topAppearance);
        dataOutput.writeInt(this.bottomAppearance);
        dataOutput.writeInt(this.leftAppearance);
        dataOutput.writeInt(this.rightAppearance);
    }

    public void readObject(DataInput dataInput) throws IOException {
        super.readObject(dataInput);
        this.frontAppearance = dataInput.readInt();
        this.backAppearance = dataInput.readInt();
        this.topAppearance = dataInput.readInt();
        this.bottomAppearance = dataInput.readInt();
        this.leftAppearance = dataInput.readInt();
        this.rightAppearance = dataInput.readInt();
    }

    public void writeConstructorParams(DataOutput dataOutput) throws IOException {
        super.writeConstructorParams(dataOutput);
        dataOutput.writeFloat(((Box)this.node).getXdimension());
        dataOutput.writeFloat(((Box)this.node).getYdimension());
        dataOutput.writeFloat(((Box)this.node).getZdimension());
    }

    public void readConstructorParams(DataInput dataInput) throws IOException {
        super.readConstructorParams(dataInput);
        this.xdim = dataInput.readFloat();
        this.ydim = dataInput.readFloat();
        this.zdim = dataInput.readFloat();
    }

    public void buildGraph() {
        if (this.frontAppearance == this.backAppearance && this.frontAppearance == this.topAppearance && this.frontAppearance == this.bottomAppearance && this.frontAppearance == this.leftAppearance && this.frontAppearance == this.rightAppearance) {
            ((Box)this.node).setAppearance((Appearance)this.control.getSymbolTable().getJ3dNode(this.frontAppearance));
        } else {
            ((Box)this.node).setAppearance(0, (Appearance)this.control.getSymbolTable().getJ3dNode(this.frontAppearance));
            ((Box)this.node).setAppearance(1, (Appearance)this.control.getSymbolTable().getJ3dNode(this.backAppearance));
            ((Box)this.node).setAppearance(4, (Appearance)this.control.getSymbolTable().getJ3dNode(this.topAppearance));
            ((Box)this.node).setAppearance(5, (Appearance)this.control.getSymbolTable().getJ3dNode(this.bottomAppearance));
            ((Box)this.node).setAppearance(3, (Appearance)this.control.getSymbolTable().getJ3dNode(this.leftAppearance));
            ((Box)this.node).setAppearance(2, (Appearance)this.control.getSymbolTable().getJ3dNode(this.rightAppearance));
        }
        super.buildGraph();
    }

    public SceneGraphObject createNode(Class clazz) {
        Box box = (Box)super.createNode(clazz, new Class[]{Float.TYPE, Float.TYPE, Float.TYPE, Integer.TYPE, Appearance.class}, new Object[]{new Float(this.xdim), new Float(this.ydim), new Float(this.zdim), new Integer(this.primflags), null});
        return box;
    }

    protected SceneGraphObject createNode() {
        return new Box(this.xdim, this.ydim, this.zdim, this.primflags, null);
    }
}

